<?php

class Events extends Controller {

	function Events()
	{
		parent::Controller();	
		$this->load->model('events_model', 'events');
		$this->load->model('venue_model', 'venue');
		$this->load->model('sections_model', 'sections');
		$this->load->model('prices_model', 'prices');
		date_default_timezone_set('Asia/Manila');
		
		parse_str($_SERVER['QUERY_STRING'],$_GET);
		$client_ip = $_SERVER['REMOTE_ADDR'];
		$filter = "10.";
		$filtered = substr($client_ip,0,strlen($filter));
		if ($filtered != $filter) {
		 
		
		}else{
			
			if (!isset($_SERVER['HTTPS']) || !$_SERVER['HTTPS']) {
				redirect('https://'.$_SERVER["HTTP_HOST"]);
			}
		}
		
		
	}
	
	function index()
	{
		$this->home();
	}
	
	function home(){
		
		$data['site_title'] = "SMTICKETS - Home";
			
		// echo "<pre>";
		// print_r($data["active_date"]);
		// echo "</pre>";
		// die();
		$data['location'] = 'Home';
		// $event_listings = $this->events->getEventIDs();
		// $data["event_listings"] = json_encode($event_listings);
		
		// $data['just_announced'] = $this->events->get_just_announced_events(12);

		// $this->load->view('home',$data);
		// $this->load->view('home_all',$data);
		
		//For Live############################
		$this->load->view('header_revamp',$data);
		$this->load->view('home_revamp',$data);
		$this->load->view('footer_revamp');
		//For Maintenance#####################
		 //$this->load->view('maintenance');
	}
	
	
	function hotEVents(){
		
		$hot_events = $this->events->get_hot_events_2(12);
		echo $hot_events;
		die();
	}
	
	function home2(){
		$data['site_title'] = "SMTICKETS - Home";
		$data['new_events'] = $this->events->get_new_events(12);
		
		$this->load->view('home2',$data);
	}
	
	function listing($category=false){		

		$data['hot_events'] = "";
		$data["events"] = $this->events->getEventsForListing($category);
		$this->load->view('header_revamp');
		$this->load->view('listings_revamp',$data);
		$this->load->view('footer_revamp');
		// $this->load->view('event_listing',$data);
	}
	
	function search($match=false){	
	
		if(!$match){
			redirect(base_url());
		}
		
		$parameters = Array(
				'match' => $match,
				'venue' => false,
				'category' => false,
				'long_title' => false,
				);
		
		if($match == 'toruk'){
		$data['pixel'] = "pixel";
		}
				
		$data['hot_events'] = "";	
		$data["events"] = $this->events->getEventsForListing($parameters);
		$this->load->view('header_revamp',$data);
		$this->load->view('listings_revamp',$data);
		$this->load->view('footer_revamp');
		// $this->load->view('event_listing',$data);
	}

	function category($category){
		$data['hot_events'] = "";	
			
		$parameters = Array(
						'category' => explode( '+or+', $category ),
						'match' => false,
						'venue' => false,
						'long_title' => false,
						);
						
						
		$data["events"] = $this->events->getEventsForListing($parameters);
		
		// $this->load->view('event_listing',$data);
		$this->load->view('header_revamp');
		$this->load->view('listings_revamp',$data);
		$this->load->view('footer_revamp');
	}
	
	function calendar($month, $day, $year){
		
		$date = $year . "-" . $month . "-" . $day;
		
		$date = date_format(date_create($date, timezone_open("GMT")),"U");
		
				
		$data['site_title'] = "SMTICKETS - Home";
		
		$parameters = Array(
				'date' => $date,
				);
				
		$data["events"] = $this->events->getEventsForCalendar($parameters);

		// echo "<pre>";
		// print_r($data["events"]);
		// echo "</pre>";
		// die();

		$this->load->view('header_revamp');
		$this->load->view('listings_revamp',$data);
		$this->load->view('footer_revamp');
		// $this->load->view('event_listing',$data);
		
	}
	
	function venue($venue_id=false) {
		
		$data['hot_events'] = "";
		
		$parameters = Array(
				'venue' => $venue_id,
				'category' => false,
				'match' => false,
				'long_title' => false,
				);
				
		$data["events"] = $this->events->getEventsForListing($parameters);
		
		// echo "<pre>";
		// print_r($data["events"]);
		// echo "</pre>";
		// die();

		$this->load->view('header_revamp');
		$this->load->view('listings_revamp',$data);
		$this->load->view('footer_revamp');
		// $this->load->view('event_listing',$data);
	}
	
	function venue_events($venue_id=false,$limit=false) {
		$data['hot_events'] = "";
		$data["element"] = json_encode($this->events->getEventsForVenue($venue_id,$limit));
			
		print_r($data["element"]);
		
		
	}

	function venue_count($limit=false) {
	
	
		/* echo "<pre>";
		print_r(json_encode($this->events->get_venue_count($limit)));
		echo "</pre>";
		die(); */
		$data['hot_events'] = "";
		$result = json_encode($this->events->get_venue_count($limit));
		print_r($result);
	}
	
	function view($event_id = false,$referrer = false ){
	
		$data['referrer'] = $referrer;
		
		$data['hot_events'] = "";
		if ($event_id=="undefined") {
			$this->load->view("error_page");
		}else{
			$data['site_title'] = $this->config->item("site_title");		
			$data["event"] = $this->events->get($event_id);
			$data["seo"] = $this->events->get_seo($event_id);
				
			// die($event_id);
				
				
			// if($event_id == "10"){
			
			// echo $event_id;
			// echo "<pre>";
			// print_r($this->events->get($event_id));
			// echo "</pre>";
			// die();
			// }
			
			$bundle_event = array(4446,5301,4137,5165); //it will use views/bundle/script.php and views/bundle/js/main.js
			
			if(in_array($event_id,$bundle_event)){
				$data['bundle'] = 1;
			}else{
				$data['bundle'] = 0;
			}
			
			$data['pixel_events_v2'] = array(5485); //pixel_events_v2
			
			if($data["event"]){
					$data["event"]['event_venue_name'] = $this->venue->get($data["event"]['event_venue_id']); 
					$data["sections"] = $this->sections->get($event_id);	
					$data["prices"] = $this->prices->get($event_id);
					
					if(!$data["event"]["convenience_charge"]){
						$data["event"]["convenience_charge"] = 0;
					}
					
				$data["event_siblings"] = $this->get_events_by_long_title($data["event"]["event_long_title"],1);
			}else{
				redirect(base_url());
			}
			
			$xml = file_get_contents('http://10.141.23.45/events/update_availability/'.$event_id); //To update availability
			
			// $this->load->view('event_page',$data);
			// $this->load->view('event_all',$data);
			$this->load->view('header_event_revamp',$data);
			$this->load->view('event_revamp',$data);
			$this->load->view('footer_revamp');
		}
	}
	
	function open(){
		
		$event_id =  $this->input->get_post("id");
		$referrer =  $this->input->get_post("ref");
		
		$this->view($event_id,$referrer);
	}
	
	
	function get_events_by_parent($event_id = false) {
	
		$data['hot_events'] = "";
	
		echo json_encode(	$this->events->get_events_by_parent($event_id)	);
		die();

	}
	
	function get_events_by_long_title($event_long_title = false,$json=false) {
	
		$data['hot_events'] = "";
	if($json){
		return json_encode(	$this->events->get_events_by_long_title($event_long_title)	);
		
	}else{
		return $this->events->get_events_by_long_title($event_long_title);
	}
		

	}
	
	
	function registration(){
		$data['hot_events'] = "";
		$data['site_title'] = $this->config->item("site_title");		
		$this->load->view('registration',$data);
	}
	
	function view_article_1() {
	
		$this->load->view('article_page_1');
	
	}
	function view_article_2() {
	
		$this->load->view('article_page_2');
	
	}
	function view_article_3() {
	
		$this->load->view('article_page_3');
	
	}
	
	function blink(){

		$this->load->view('article_page_4');
	}

	//FOR AJAX  CALLS ++++++++++++++++++++++++++++++++++
	function getEventDatesbyLongTitle(){
		$long_title = $this->input->get_post("long_title");
		
			
		$parameters = Array(
				'venue' => false,
				'category' => false,
				'match' => false,
				'long_title' => urlencode($long_title)
				);
				
		$event_array = $this->events->getEventsForListing($parameters);
		echo json_encode($event_array);	
	}
	
	function getEventsforQuickBuy(){
		
			$all_events = $this->events->getEventsForListing();
			echo json_encode($all_events);
	}
	
	
		
	function getEventlistings(){
		$event_listings = $this->events->getEventIDs();
		echo $data["event_listings"] = json_encode($event_listings);	
	}
	
	
	
	
	function check_promo(){
		
		$promo_code = $this->input->post("promo_code");
		echo $promo_code;
		
		echo "success";
	}
	
	function getLastDateModified(){
		echo $lastDateModified = $this->events->getLastDateModified();
	}

	function getRemainingSeat($section_id,$date=false){

		$url = $this->config->item("url_base") . "/generic_mod/getRemainingSeat/" . $section_id;
		
		if($date){
			$url = $url . "/" . $date;
		}
		
		$result = file_get_contents($url);
		
		$result = new SimpleXMLElement($result);
		$result = json_encode($result);
		
		die($result);
	}
	
	function getActiveDates(){
		$active_date = $this->events->getActiveEventsDate();
		echo json_encode($active_date);
	}
	
	function get_ticket_count_customer($username,$event_id){
		
		$url = $this->config->item("url_base")."/transaction/get_ticket_count_customer/".$username."/".$event_id;
		$result = file_get_contents($url);
		echo $result;
	}

}

/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */